package gov.va.med.mhv.journal.dto;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.journal.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.journal.web.util.JournalDecorator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ActivityJournalDTO implements Serializable {

	private static final long serialVersionUID = 1L;

	private Long activityJournalId;
	private Integer oplock;
	private Date createdDate;
	private String comments;
	private Date journalDate;
	private Date modifiedDate;
	// private Set<MealItemDTO> mealItems;
	private Set<ActivityDetailDTO> activityDetails;
	private Long userId;
	private UserProfileDTO userProfile;

	private String dispJournalDate;
	private int dayNoOfWeek;
	private String summary;
	private String abbrWeekDay;
	private String weekDay;
	private String activityTypeCount;

	// below lists are used in edit/delete page to display list of activity
	// types summary
	private List<String> aerobicCardioStr;
	private List<String> weightsStr;
	private List<String> otherStr;

	private List<ActivityDetailDTO> aerobicCardiaoType;
	private List<ActivityDetailDTO> weightsType;
	private List<ActivityDetailDTO> otherType;

	private Long activityDetailId;
	private String activityType;
	private BigDecimal distDuration;
	private String measure;
	private String intensity;
	private String timeOfDay;
	private BigDecimal noOfSets;
	private BigDecimal noOfReps;
	private String activityDesc;
	
	public ActivityJournalDTO() {
	}
	
	public ActivityJournalDTO(ActivityJournalDTO activityJournal) {
		super();
		this.activityJournalId = activityJournal.getActivityJournalId();
		this.oplock = activityJournal.getOplock();
		this.createdDate = activityJournal.getCreatedDate();
		this.comments = activityJournal.getComments();
		this.journalDate = activityJournal.getJournalDate();
		this.modifiedDate = activityJournal.getModifiedDate();
		this.activityDetails = new HashSet<ActivityDetailDTO>();
		if (null != activityJournal.getActivityDetails()) {
			this.activityDetails.addAll(activityJournal.getActivityDetails());
		}
		this.userId = activityJournal.getUserId();
		this.activityDetailId = activityJournal.getActivityDetailId();
		this.activityType = activityJournal.getActivityType();
		this.distDuration = activityJournal.getDistDuration();
		this.measure = activityJournal.getMeasure();
		this.intensity = activityJournal.getIntensity();
		this.timeOfDay = activityJournal.getTimeOfDay();
		this.noOfSets = activityJournal.getNoOfSets();
		this.noOfReps = activityJournal.getNoOfReps();
		this.activityDesc = activityJournal.getActivityDesc();
	}
	
	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getJournalDate() {
		return journalDate;
	}

	public void setJournalDate(Date journalDate) {
		this.journalDate = journalDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public UserProfileDTO getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfileDTO userProfile) {
		this.userProfile = userProfile;
	}

	public void setDispJournalDate(String dispJournalDate) {
		this.dispJournalDate = dispJournalDate;
	}

	public int getDayNoOfWeek() {
		return dayNoOfWeek;
	}
	
	public void setDayNoOfWeek(int dayNoOfWeek) {
		this.dayNoOfWeek = dayNoOfWeek;
	}
	
	public String getAbbrWeekDay() {
		return JournalDecorator.getAbbrDayOfWeek(getJournalDate());
	}

	public void setAbbrWeekDay(String abbrWeekDay) {
		this.abbrWeekDay = abbrWeekDay;
	}

	public String getWeekDay() {
		return JournalDecorator.getDayOfWeek(getJournalDate());
	}

	public void setWeekDay(String weekDay) {
		this.weekDay = weekDay;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public Long getActivityJournalId() {
		return activityJournalId;
	}

	public void setActivityJournalId(Long activityJournalId) {
		this.activityJournalId = activityJournalId;
	}

	public Set<ActivityDetailDTO> getActivityDetails() {
		if (activityDetails == null) {
			activityDetails = new HashSet<ActivityDetailDTO>();
		}
		return activityDetails;
	}

	public void setActivityDetails(Set<ActivityDetailDTO> activityDetails) {
		this.activityDetails = activityDetails;
	}

	public String getSummary() {
		this.summary = JournalDecorator.getActivityJournalSummary(this);
		return summary;
	}

	public String getActivityTypeCount() {
		return JournalDecorator.getActivityTypeCount(this);
	}

	public void setActivityTypeCount(String activityTypeCount) {
		this.activityTypeCount = activityTypeCount;
	}

	public List<String> getAerobicCardioStr() {
		return JournalDecorator.getDecoratedActivityTypes(this,
				ActivityTypeEnumeration.AEROBIC.getActivityType());
	}

	public void setAerobicCardioStr(List<String> aerobicCardioStr) {
		this.aerobicCardioStr = aerobicCardioStr;
	}

	public List<String> getWeightsStr() {
		return JournalDecorator.getDecoratedActivityTypes(this,
				ActivityTypeEnumeration.WEIGHTS.getActivityType());
	}

	public void setWeightsStr(List<String> weightsStr) {
		this.weightsStr = weightsStr;
	}

	public List<String> getOtherStr() {
		return JournalDecorator.getDecoratedActivityTypes(this,
				ActivityTypeEnumeration.OTHER.getActivityType());
	}

	public void setOtherStr(List<String> otherStr) {
		this.otherStr = otherStr;
	}

	public List<ActivityDetailDTO> getAerobicCardiaoType() {
		return JournalDecorator.getActivityDetailSubList(getActivityDetails(),
				ActivityTypeEnumeration.AEROBIC.getActivityType());
	}

	public void setAerobicCardiaoType(List<ActivityDetailDTO> aerobicCardiaoType) {
		this.aerobicCardiaoType = aerobicCardiaoType;
	}

	public List<ActivityDetailDTO> getWeightsType() {
		return JournalDecorator.getActivityDetailSubList(getActivityDetails(),
				ActivityTypeEnumeration.WEIGHTS.getActivityType());
	}

	public void setWeightsType(List<ActivityDetailDTO> weightsType) {
		this.weightsType = weightsType;
	}

	public List<ActivityDetailDTO> getOtherType() {
		return JournalDecorator.getActivityDetailSubList(getActivityDetails(),
				ActivityTypeEnumeration.OTHER.getActivityType());
	}

	public void setOtherType(List<ActivityDetailDTO> otherType) {
		this.otherType = otherType;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public BigDecimal getDistDuration() {
		DecimalFormat df = new DecimalFormat("0.####");
		return (null != distDuration) ? new BigDecimal(df.format(distDuration)) : distDuration;
	}

	public void setDistDuration(BigDecimal distDuration) {
		this.distDuration = distDuration;
	}

	public String getMeasure() {
		return measure;
	}

	public void setMeasure(String measure) {
		this.measure = measure;
	}

	public String getIntensity() {
		return intensity;
	}

	public void setIntensity(String intensity) {
		this.intensity = intensity;
	}

	public String getTimeOfDay() {
		return timeOfDay;
	}

	public void setTimeOfDay(String timeOfDay) {
		this.timeOfDay = timeOfDay;
	}

	public BigDecimal getNoOfSets() {
		DecimalFormat df = new DecimalFormat("0.####");
		return (null != noOfSets) ? new BigDecimal(df.format(noOfSets)) : noOfSets;
	}

	public void setNoOfSets(BigDecimal noOfSets) {
		this.noOfSets = noOfSets;
	}

	public BigDecimal getNoOfReps() {
		DecimalFormat df = new DecimalFormat("0.####");
		return (null != noOfReps) ? new BigDecimal(df.format(noOfReps)) : noOfReps;
	}

	public void setNoOfReps(BigDecimal noOfReps) {
		this.noOfReps = noOfReps;
	}

	public String getActivityDesc() {
		return activityDesc;
	}

	public void setActivityDesc(String activityDesc) {
		this.activityDesc = activityDesc;
	}

	public Long getActivityDetailId() {
		return activityDetailId;
	}

	public void setActivityDetailId(Long activityDetailId) {
		this.activityDetailId = activityDetailId;
	}

	public String getDispJournalDate() {
		return JournalDecorator.formatDate(getJournalDate());
	}

	@Override
	public String toString() {
		return "ActivityJournalDTO [activityJournalId=" + activityJournalId + ", oplock=" + oplock + ", createdDate=" + createdDate + ", comments=" + comments
				+ ", journalDate=" + journalDate + ", modifiedDate=" + modifiedDate + ", activityDetails=" + activityDetails + ", userId=" + userId
				+ ", userProfile=" + userProfile + ", dispJournalDate=" + dispJournalDate + ", dayNoOfWeek=" + dayNoOfWeek + ", summary=" + summary
				+ ", abbrWeekDay=" + abbrWeekDay + ", weekDay=" + weekDay + ", activityTypeCount=" + activityTypeCount + ", aerobicCardioStr="
				+ aerobicCardioStr + ", weightsStr=" + weightsStr + ", otherStr=" + otherStr + ", aerobicCardiaoType=" + aerobicCardiaoType + ", weightsType="
				+ weightsType + ", otherType=" + otherType + ", activityDetailId=" + activityDetailId + ", activityType=" + activityType + ", distDuration="
				+ distDuration + ", measure=" + measure + ", intensity=" + intensity + ", timeOfDay=" + timeOfDay + ", noOfSets=" + noOfSets + ", noOfReps="
				+ noOfReps + ", activityDesc=" + activityDesc + "]";
	}
	
	
}
